package cz.upol.jj2.lab01;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXExampleR {
	
	public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {

		InputStream input = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><foo>Lorem ipsum</foo><foo bar=\"qux\"/><foo nobar=\"foobar\"><baz>test</baz></foo></root>".getBytes());

		//nachystani parseru
		SAXParserFactory parserFactory = SAXParserFactory.newInstance();
		SAXParser parser = parserFactory.newSAXParser();

		//spusteni parseru s objektem popisujícím reakce na udalosti
		parser.parse(input, new DefaultHandler() {
			
			private int level = 0;

			//reakce na zacatek dokumentu
			@Override
			public void startDocument() throws SAXException {
				System.out.println("Zahajeno cteni dokumentu");
				level++;
			}

			//reakce na konec dokumentu
			@Override
			public void endDocument() throws SAXException {
				System.out.println("Konec");
				level--;
			}

			//reakce na zacatek elementu (oteviraci tag)
			@Override
			public void startElement(String uri, String localName,
					String qName, Attributes attributes) throws SAXException {
				padding();
				System.out.println("Precten element: " + qName);
				String value = attributes.getValue("bar");
				if (value != null)  {
					level++;
					padding();
					System.out.println("ma attribut bar='" + value + "'");
					level--;
				}
				level++;
			}

			//reakce na konec elementu (uzaviraci tag)
			@Override
			public void endElement(String uri, String localName, String qName)
					throws SAXException {
				level--;
				padding();
				System.out.println("Konec elementu: " + qName);
			}

			//reakce na textovy obsah
			@Override
			public void characters(char[] ch, int start, int length)
					throws SAXException {
				padding();
				//jak vime, pole charu s "pointrem" a delkou neni String, ale lze to snadno prevest
				System.out.println("Text: " + new String(ch, start, length));
			}
			
			private void padding() {
				for (int i = 0; i < level; i++)
					System.out.print("   ");
			}
		});
	}
}
