package cz.upol.jj2.lab01;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;


public class StAXExampleR {

	public static void main(String[] args) throws XMLStreamException {
		InputStream input = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><foo>Lorem ipsum</foo><foo bar=\"qux\"/><foo nobar=\"foobar\"><baz>test</baz></foo></root>".getBytes());

		//nachystani parseru
		XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
		XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(input);
		
		int level = 0;

		//parsovani samotne je rizeno rucne - tedy nereagujeme na udalosti, ale vyvolavame si je sami
		boolean done = false;
		while (!done) {
			switch (reader.getEventType()) { //jaká udalost nas ted ceka?
			case XMLStreamReader.START_ELEMENT:  //otevírací tag
				padding(level++);
				System.out.println("Precten element: " + reader.getName());
				String value = reader.getAttributeValue(null, "bar");
				if (value != null)  {
					padding(level+1);
					System.out.println("ma attribut bar='" + value + "'");
				}
				break;
				
			case XMLStreamReader.END_ELEMENT:  //uzaviraci tag
				padding(--level);
				System.out.println("Konec elementu: " + reader.getName());
				break;
			
			case XMLStreamReader.CHARACTERS:  //textovy obsah
				padding(level);
				System.out.println("Text: " + reader.getText());
				break;
				
			default:
				break;
			}
			if (reader.hasNext()) {
				reader.next(); //pokud existuje dalsi udalost, sem s ni...
			}
			else
			{
				done = true;  //jinak koncime
			}
		}

	}
	
	private static void padding(int level) {
		for (int i = 0; i < level; i++)
			System.out.print("   ");
	}

}