# Počítadlo zobrazující svoji hodnotu v popisku

import micro_widget as mw

# Počítadlo (counter) bude pole ["counter", value, label].

def make_counter(window):
    label = mw.make_label(window)
    counter = ["counter", 0, label]
    ensure_counter_label(counter)
    return counter

def get_counter_label(counter):
    return counter[2]
    
def get_counter_value(counter):
    return counter[1]

def ensure_counter_label(counter):
    label = get_counter_label(counter)
    value = get_counter_value(counter)
    mw.set_label_text(label, str(value))

def set_counter_value(counter, value):
    counter[1] = value
    ensure_counter_label(counter)

def inc_counter(counter):
    set_counter_value(counter,
                      get_counter_value(counter) + 1)


window = mw.make_window()
counter = make_counter(window)
inc_counter(counter)

# Změny se projevují v okně:
"""
>>> inc_counter(counter)
>>> inc_counter(counter)
>>> set_counter_value(counter, 0)
"""
