# Počítadlo s tlačítkem

import micro_widget as mw

# Počítadlo (counter) bude pole ["counter", value, label, button].
BUTTON_DISTANCE = 20

def make_counter(window):
    label = mw.make_label(window)
    button = mw.make_button(window)
    mw.set_button_y(button, BUTTON_DISTANCE)
    mw.set_button_text(button, "+")
    counter = ["counter", 0, label, button]
    mw.set_button_data(button, counter)
    mw.set_button_click_callback(button, counter_button_click_callback)
    
    ensure_counter_label(counter)
    return counter

def get_counter_label(counter):
    return counter[2]
    
def get_counter_value(counter):
    return counter[1]

def ensure_counter_label(counter):
    label = get_counter_label(counter)
    value = get_counter_value(counter)
    mw.set_label_text(label, str(value))

def set_counter_value(counter, value):
    counter[1] = value
    ensure_counter_label(counter)

def inc_counter(counter):
    set_counter_value(counter,
                      get_counter_value(counter) + 1)

def counter_button_click_callback(button):
    counter = mw.get_button_data(button)
    inc_counter(counter)
    
window = mw.make_window()
counter = make_counter(window)

