# Počítadla s tlačítkem

import micro_widget as mw

# Počítadlo (counter) bude pole ["counter", value, label, button].
BUTTON_DISTANCE = 20

def make_counter(window):
    label = mw.make_label(window)
    button = mw.make_button(window)
    mw.set_button_y(button, BUTTON_DISTANCE)
    mw.set_button_text(button, "+")
    counter = ["counter", 0, label, button]
    mw.set_button_data(button, counter)
    mw.set_button_click_callback(button, counter_button_click_callback)
    
    ensure_counter_label(counter)
    return counter

def get_counter_label(counter):
    return counter[2]

def get_counter_button(counter):
    return counter[3]
    
def get_counter_value(counter):
    return counter[1]

def ensure_counter_label(counter):
    label = get_counter_label(counter)
    value = get_counter_value(counter)
    mw.set_label_text(label, str(value))

def set_counter_value(counter, value):
    counter[1] = value
    ensure_counter_label(counter)

# Nastavení souřadnic

def get_counter_x(counter):
    label = get_counter_label(counter)
    return mw.get_label_x(label)

def get_counter_y(counter):
    label = get_counter_label(counter)
    return mw.get_label_y(label)

def set_counter_x(counter, x):
    label = get_counter_label(counter)
    button = get_counter_button(counter)
    mw.set_label_x(label, x)
    mw.set_button_x(button, x)

def set_counter_y(counter, y):
    label = get_counter_label(counter)
    button = get_counter_button(counter)
    mw.set_label_y(label, y)
    mw.set_button_y(button, y + BUTTON_DISTANCE)

def inc_counter(counter):
    set_counter_value(counter,
                      get_counter_value(counter) + 1)


def counter_button_click_callback(button):
    counter = mw.get_button_data(button)
    inc_counter(counter)

# Dvě nezávislá počítadla:    
window = mw.make_window()
counter1 = make_counter(window)
counter2 = make_counter(window)
set_counter_y(counter1, 50) 

