# Počítadlo
# je abstraktní datová struktura
# typu counter s položkou value.
#
# Počítadlo je ovládací prvek.
#
# Volání:
#   inc_counter_value(counter) => None
# inkrementuje hodnotu počítadla.

from pomw import *

def make_counter():
    label = Label()
    button = Button().set_text("+").move(0, 30)
    counter = Group().set_items([label, button])
    button.set_data(counter)
    button.set_click_callback(counter_button_click_callback)
    set_counter_value(counter, 0)
    return counter

def get_counter_label(counter):
    return counter.get_items()[0]
    
def get_counter_value(counter):
    return counter.get_data()

def set_counter_value(counter, value):
    counter.set_data(value)
    label = get_counter_label(counter)
    label.set_text(str(value))

def inc_counter_value(counter):
    set_counter_value(counter,
                      get_counter_value(counter) + 1)

def counter_button_click_callback(button):
    counter = button.get_data()
    inc_counter_value(counter)
    
                      
# Ukázka okna s dvěma počítadly.
window = Window()
counter1 = make_counter()
counter2 = make_counter().move(0, 100)
group = Group().set_items([counter1, counter2])
window.set_widget(group)

