# Úhel

# Úhel má dvě vlastnosti.
# První vlastnost rad udává jeho velikost v radiánech
# a druhá vlastnost deg udává jeho velikost ve stupních.

from math import pi

class Angle:
    def __init__(self):
        self.rad = 0 # úhel v radiánech
        
    def get_rad(self):
        return self.rad

    def set_rad(self, rad):
        self.rad = rad
        return self

    def get_deg(self):
        return self.get_rad() / (2 * pi) * 360

    def set_deg(self, deg):
        return self.set_rad(deg / 360 * 2 * pi)
    


"""
>>> angle = Angle()
>>> angle.set_rad(pi)
<__main__.Angle object at 0x1031567b0>
>>> angle.get_deg()
180.0
>>> angle.set_deg(90)
<__main__.Angle object at 0x1031567b0>
>>> angle.get_rad()
1.5707963267948966
>>> pi / 2
1.5707963267948966
"""


