# Číselná položka formuláře
from omw import *

def is_decimal(string):
    if string == "":
        return False
    for char in string:
        if not ("0" <= char <= "9"):
            return False
    return True

"""
>>> is_decimal("12")
True
>>> is_decimal("12a")
False
"""
    
class IntegerEntry(Entry):
    def get_semantic_value(self):
        return int(self.get_value())

    def set_semantic_value(self, value):
        return self.set_value(str(value))
    
    def is_valid(self):
        return is_decimal(self.get_value())
        
"""    
ie = IntegerEntry()
w = Window().set_widget(ie)
"""

class IntegerEntryField(Group):
    def __init__(self):
        super().__init__()
        label = Label()
        entry = IntegerEntry().move(0, 20)
        message = Label().move(0, 50)
        self.set_items([label, entry, message])
   
    def get_label(self):
        return self.get_items()[0]

    def get_entry(self):
        return self.get_items()[1]

    def get_message(self):
        return self.get_items()[2]
    
    def get_value(self):
        return self.get_entry().get_semantic_value()

    def set_value(self, value):
        self.get_entry().set_semantic_value(value)
        return self

    def get_label_text(self):
        return self.get_label().get_text()

    def set_label_text(self, text):
        self.get_label().set_text(text)
        return self

    def validate(self):
        if self.get_entry().is_valid():
            text = ""
        else:
            text = "Není číslo."
        self.get_message().set_text(text)

ief = IntegerEntryField()
ief.set_label_text("Věk:")
w = Window().set_widget(ief)
