# Skupina přepínačů s knihovnou omw
from omw import *

class RadiobuttonGroup(Group):
    def check_item(self, item):
        if not isinstance(item, Radiobutton):
            raise TypeError("items of a radiobutton group have to be radiobuttons")
        return self

    def get_selected(self):
        for rb in self.get_items():
            if rb.is_selected():
                return rb

    def set_selected(self, radiobutton):
        for rb in self.get_items():
            rb.set_value(rb == radiobutton)
        return self

    def deselect_all(self):
        return self.set_selected(None)

    def deselect_others(self, radiobutton):
        for rb in self.get_items():
            if rb != radiobutton:
                rb.set_value(False)
        return self
        
    def ev_radiobutton_change(self, sender):
        if sender.is_selected():
            self.deselect_others(sender)
        

w = Window()
r1 = Radiobutton()
r2 = Radiobutton().move(0, 20)
g = RadiobuttonGroup().set_items([r1, r2])
w.set_widget(g)

"""
>>> r1
<omw.Radiobutton object at 0x10b512dd0>
>>> r2
<omw.Radiobutton object at 0x10b5fa3d0>
>>> g.get_selected()
>>> g.set_selected(r1)
<__main__.RadiobuttonGroup object at 0x10b5fa390>
>>> g.get_selected()
<omw.Radiobutton object at 0x10b512dd0>
>>> g.set_selected(r2)
<__main__.RadiobuttonGroup object at 0x10b5fa390>
>>> g.get_selected()
<omw.Radiobutton object at 0x10b5fa3d0>
>>> g.deselect_all()
<__main__.RadiobuttonGroup object at 0x10b5fa390>
>>> g.get_selected()
"""
# Zatím nefunguje přepínání kliknutím.
