# Počítadlo bez zobrazování
from proto import *

# počítadlo je klon základního objektu
counter = obj.clone().set_name("counter")

# klon na testování
counter1 = counter.clone()

# přidáme hodnotu počítadla jako vlastnost value
counter.add_slot("value")
counter.set_value(0)

# test
"""
>>> counter1.value()
0
>>> counter1.set_value(2)
<counter at 0x10b4f96d0>
>>> counter1.value()
2
"""

# inkrementace počítadla
def counter_inc(resend, self):
    self.set_value(self.value() + 1)
    return self

counter.set_slot("inc", counter_inc)

# test
"""
>>> counter1.set_value(0)
<counter at 0x10a75ab10>
>>> counter1.inc()
<counter at 0x10a75ab10>
>>> counter1.value()
1
"""
