# Počítadlo s hodnotou
from pmw import *

# počítadlo z minula
counter = group.clone().set_name("counter")

counter_label = label.clone()
counter_label.set_text("0")

counter_button = button.clone()
counter_button.set_text("+")
counter_button.move(0, 20)

counter.set_items([counter_label, counter_button])

# klon na testování
counter1 = counter.clone()

# vlastnosti label a button pro čtení
def counter_label(resend, self):
    return self.items()[0]

counter.set_slot("label", counter_label)

def counter_button(resend, self):
    return self.items()[1]

counter.set_slot("button", counter_button)

# test
"""
>>> counter1.label()
<label at 0x107f3d190>
>>> counter1.button()
<button at 0x106118f90>
"""

# přidáme vlastnost value
counter.set_slot("value", 0)

def counter_set_value(resend, self, value):
    self.set_slot("value", value)
    label = self.label()
    label.set_text(str(value))
    return self

counter.set_slot("set_value", counter_set_value)

# test
"""
>>> counter1.set_value(1)
<counter at 0x10f1f8fd0>
>>> counter1.value()
1
>>> counter1.label().text()
'1'
"""

# inkrementace počítadla
def counter_inc(resend, self):
    self.set_value(self.value() + 1)
    return self

counter.set_slot("inc", counter_inc)

# test
"""
>>> counter1.set_value(0)
<group at 0x10dfb0d90>
>>> counter1.inc()
<group at 0x10dfb0d90>
>>> counter1.value()
1
"""

# zobrazíme počítadlo
window1 = window.clone()
window1.set_widget(counter1)
window1.display()

# Inkrementace způsobí změnu okna.
"""
counter1.inc()
"""
