# Implementace spojových seznamů:
from lst import *

# Testovací seznam:
test_lst = cons(1, cons(2, cons(3, cons(4, empty))))

# Prvek na indexu:

def list_nth(lst, i):
    return (first(lst)
            if i == 0
            else list_nth(rest(lst), i - 1))

"""
>>> list_nth(test_lst, 2)
3
"""

# Seznam čísel.
def list_range(m, n):
    return (empty
            if m >= n
            else cons(m, list_range(m + 1, n)))

"""
    list_range(0, 2)
=== cons(0, cons(1, empty))
"""

# Každý prvek splňuje predikát.
def is_every(predicate, lst):
    return (is_empty(lst)
            or (predicate(first(lst))
                and is_every(predicate, rest(lst))))
"""
>>> is_every(lambda x: x > 2, cons(3, cons(5, empty)))
True
>>> is_every(lambda x: x > 2, cons(1, cons(5, empty)))
False
"""




# První prvek splňující predikát:
def list_find(pred, lst):
    return [] if is_empty(lst) else ([first(lst)]
                                     if pred(first(lst))
                                     else list_find(pred, rest(lst)))

"""
>>> list_find(lambda x: x >= 2, test_lst)
[2]
>>> list_find(lambda x: x < 1, test_lst)
[]
"""
            
