const express = require('express');
const redis = require('redis');
const os = require('os');

const app = express();
const port = 3000;

// Konfigurace klienta pro Redis (host 'redis' odpovídá názvu služby v docker-compose)
const client = redis.createClient({
    socket: {
        host: 'redis',
        port: 6379
    }
});

client.on('error', err => console.log('Redis Client Error', err));

(async () => {
    await client.connect(); // Připojení k DB před startem serveru
})();

app.get('/', async (req, res) => {
    // 1. Zvýšíme počítadlo v sdílené databázi (Atomic operace)
    const visits = await client.incr('visits');

    // 2. Zjistíme ID kontejneru (hostname), který požadavek vyřizuje
    const containerId = os.hostname();

    // 3. Odpovíme uživateli
    res.send(`
        <p>Tento požadavek vyřídil kontejner: <strong>${containerId}</strong></p>
        <p>Celkový počet návštěv (uloženo v Redis): <strong>${visits}</strong></p>
    `);
});

app.listen(port, () => {
    console.log(`App running on port ${port}`);
});
