const express = require('express');
const redis = require('redis');
const app = express();

const client = redis.createClient({ socket: { host: process.env.REDIS_HOST } });
client.connect();

app.get('/order/:id', async (req, res) => {
    const orderId = req.params.id;

    // Vložíme úlohu do fronty 'orders' (Left Push)
    await client.lPush('orders', orderId);

    console.log(`[API] Objednávka ${orderId} přijata a vložena do fronty.`);

    // Okamžitá odpověď uživateli (nečekáme na zpracování)
    res.send(`Objednávka ${orderId} byla přijata ke zpracování.\n`);
});

app.listen(3000, () => console.log('Producer API běží na portu 3000'));
