const redis = require('redis');
const os = require('os');

const client = redis.createClient({ socket: { host: process.env.REDIS_HOST } });

(async () => {
    await client.connect();
    console.log(`[Worker ${os.hostname()}] Připraven k práci...`);

    while (true) {
        try {
            // Blokující operace: Čekej, dokud ve frontě 'orders' něco nebude (Right Pop)
            // Timeout 0 znamená čekat do nekonečna
            const result = await client.brPop('orders', 0);
            const orderId = result.element;

            console.log(`[Worker ${os.hostname()}] Zpracovávám objednávku: ${orderId}...`);

            // Simulace těžké práce (3 sekundy)
            await new Promise(resolve => setTimeout(resolve, 3000));

            console.log(`[Worker ${os.hostname()}] HOTOVO: Objednávka ${orderId} vyřízena.`);
        } catch (err) {
            console.error("Chyba:", err);
        }
    }
})();
